<?php
session_start();
if (!isset($_SESSION['nama_cs'])) {
  header("Location: login_cs.php");
  exit;
}

$conn = new mysqli("localhost", "odmr9632_userdb", "@Sukabumi2018", "odmr9632_order_db");
$nama_cs = $_SESSION['nama_cs'];

// Handle filter
$produk = $_GET['produk'] ?? '';
$tanggal_awal = $_GET['tanggal_awal'] ?? '';
$tanggal_akhir = $_GET['tanggal_akhir'] ?? '';
$where = "WHERE nama_cs = '$nama_cs'";

if ($produk) {
  $where .= " AND nama_produk = '$produk'";
}
if ($tanggal_awal && $tanggal_akhir) {
  $where .= " AND tanggal BETWEEN '$tanggal_awal' AND '$tanggal_akhir'";
}

$result = $conn->query("SELECT * FROM orders $where ORDER BY tanggal DESC");

// Ambil semua nama produk
$produk_list = $conn->query("SELECT DISTINCT nama_produk FROM orders WHERE nama_cs = '$nama_cs'");
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Order</title>
  <style>
    body { font-family: 'Segoe UI', sans-serif; background: #f7f7f7; padding: 20px; }
    .filter-box, table { background: white; padding: 20px; border-radius: 10px; max-width: 1000px; margin: auto; box-shadow: 0 0 10px rgba(0,0,0,0.05); }
    h2 { text-align: center; }
    label { margin-right: 10px; }
    select, input[type=date] { padding: 6px; border: 1px solid #ccc; border-radius: 6px; margin-right: 10px; }
    button { padding: 8px 15px; background: #4CAF50; color: white; border: none; border-radius: 6px; cursor: pointer; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
    th { background: #f0f0f0; }
    .edit-btn { background: #2196F3; color: white; border: none; padding: 6px 10px; border-radius: 4px; cursor: pointer; }
  </style>
</head>
<body>
  <h2>✏️ Edit Order - <?= htmlspecialchars($nama_cs) ?></h2>

  <form method="GET" class="filter-box">
    <label for="produk">Produk:</label>
    <select name="produk">
      <option value="">Semua</option>
      <?php while($row = $produk_list->fetch_assoc()): ?>
        <option value="<?= $row['nama_produk'] ?>" <?= $produk == $row['nama_produk'] ? 'selected' : '' ?>><?= $row['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>

    <label for="tanggal_awal">Dari:</label>
    <input type="date" name="tanggal_awal" value="<?= $tanggal_awal ?>">

    <label for="tanggal_akhir">Sampai:</label>
    <input type="date" name="tanggal_akhir" value="<?= $tanggal_akhir ?>">

    <button type="submit">Filter</button>
  </form>

  <table>
    <thead>
      <tr>
        <th>No</th>
        <th>Tanggal</th>
        <th>Produk</th>
        <th>Customer</th>
        <th>No. WA</th>
        <th>Provinsi</th>
        <th>Kota</th>
        <th>Kecamatan</th>
        <th>Alamat</th>
        <th>Qty</th>
        <th>Harga</th>
        <th>Ongkir</th>
        <th>Fee COD</th>
        <th>Status</th>
        <th>No Resi</th>
        <th>Status Paket</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result->num_rows > 0): $no = 1; while($r = $result->fetch_assoc()): ?>
      <tr>
        <td><?= $no++ ?></td>
        <td><?= $r['tanggal'] ?></td>
        <td><?= $r['nama_produk'] ?></td>
        <td><?= $r['nama_customer'] ?></td>
        <td><?= $r['no_wa'] ?></td>
        <td><?= $r['provinsi'] ?></td>
        <td><?= $r['kota'] ?></td>
        <td><?= $r['kecamatan'] ?></td>
        <td><?= $r['alamat'] ?></td>
        <td><?= $r['qty'] ?></td>
        <td>Rp<?= number_format($r['harga_jual'], 0, ',', '.') ?></td>
        <td><?= $r['ongkir'] ?></td>
        <td><?= $r['fee_cod'] ?></td>
        <td><?= $r['status_pengiriman'] ?></td>
        <td><?= $r['no_resi'] ?></td>
        <td><?= $r['status_paket'] ?></td>
        <td><a href="edit_form.php?id=<?= $r['id'] ?>" class="edit-btn">Edit</a></td>
      </tr>
      <?php endwhile; else: ?>
        <tr><td colspan="17">Tidak ada data ditemukan</td></tr>
      <?php endif; ?>
    </tbody>
  </table>

  <div style="text-align: center; margin-top: 30px;">
    <a href="menu_cs.php" style="
      display: inline-block;
      margin: 10px;
      padding: 10px 20px;
      background-color: #2196F3;
      color: white;
      text-decoration: none;
      border-radius: 6px;
      font-size: 16px;">Kembali ke Menu CS</a>

    <a href="index.php" style="
      display: inline-block;
      margin: 10px;
      padding: 10px 20px;
      background-color: #9e9e9e;
      color: white;
      text-decoration: none;
      border-radius: 6px;
      font-size: 16px;">Kembali ke Menu Utama</a>
  </div>
 </body>
</html>
