<?php
session_start();
if (!isset($_SESSION['warehouse'])) {
  header("Location: login_warehouse.php");
  exit;
}

<?php
$host = "localhost";
$user = "odmr9632_userdb";
$pass = "@Sukabumi2018";
$db   = "odmr9632_order_db";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}
?>
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$tgl1 = $_GET['tgl1'] ?? '';
$tgl2 = $_GET['tgl2'] ?? '';
$produk_filter = $_GET['produk'] ?? '';
$jenis_filter = $_GET['jenis'] ?? '';

$where = "WHERE 1=1";
if ($tgl1 && $tgl2) $where .= " AND tanggal BETWEEN '$tgl1' AND '$tgl2'";
if ($produk_filter) $where .= " AND nama_produk = '" . $conn->real_escape_string($produk_filter) . "'";
if ($jenis_filter) $where .= " AND jenis = '" . $conn->real_escape_string($jenis_filter) . "'";

$produk_list = $conn->query("SELECT DISTINCT nama_produk FROM riwayat_stok ORDER BY nama_produk");
$jenis_list = ['Masuk', 'Keluar', 'Rusak', 'Hilang', 'Lainnya'];

$query = "SELECT * FROM riwayat_stok $where ORDER BY tanggal DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Riwayat Stok</title>
  <style>
    body { font-family: Arial; background: #f4f4f4; padding: 20px; }
    .container { background: white; max-width: 1000px; margin: auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #e53935; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
    th { background: #e53935; color: white; }
    .filter-form select, .filter-form input { padding: 6px; margin: 5px; border-radius: 5px; border: 1px solid #ccc; }
    .btn { background: #4caf50; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; }
    .btn:hover { background: #388e3c; }
  </style>
</head>
<body>
<div class="container">
  <h2>📋 Riwayat Perubahan Stok</h2>

  <form method="get" class="filter-form" style="text-align:center;">
    <label>Tanggal:</label>
    <input type="date" name="tgl1" value="<?= $tgl1 ?>"> -
    <input type="date" name="tgl2" value="<?= $tgl2 ?>">

    <label>Produk:</label>
    <select name="produk">
      <option value="">-- Semua --</option>
      <?php while ($pr = $produk_list->fetch_assoc()): ?>
        <option value="<?= $pr['nama_produk'] ?>" <?= $produk_filter == $pr['nama_produk'] ? 'selected' : '' ?>><?= $pr['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>

    <label>Jenis:</label>
    <select name="jenis">
      <option value="">-- Semua --</option>
      <?php foreach ($jenis_list as $j): ?>
        <option value="<?= $j ?>" <?= $jenis_filter == $j ? 'selected' : '' ?>><?= $j ?></option>
      <?php endforeach; ?>
    </select>

    <button type="submit" class="btn">🔍 Filter</button>
  </form>

  <table>
    <tr><th>Tanggal</th><th>Produk</th><th>Jenis</th><th>Jumlah</th><th>Keterangan</th><th>Petugas</th></tr>
    <?php if ($result->num_rows > 0): ?>
      <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
          <td><?= htmlspecialchars($row['tanggal']) ?></td>
          <td><?= htmlspecialchars($row['nama_produk']) ?></td>
          <td><?= htmlspecialchars($row['jenis']) ?></td>
          <td><?= (int)$row['qty'] ?></td>
          <td><?= htmlspecialchars($row['keterangan']) ?></td>
          <td><?= htmlspecialchars($row['petugas']) ?></td>
        </tr>
      <?php endwhile; ?>
    <?php else: ?>
      <tr><td colspan="6">Tidak ada data.</td></tr>
    <?php endif; ?>
  </table>

  <div style="text-align:center; margin-top:20px;">
    <a href="dashboard_warehouse.php" class="btn" style="background:gray">⬅️ Kembali ke Dashboard</a>
    <a href="export_riwayat_stok_excel.php?tgl1=<?= $tgl1 ?>&tgl2=<?= $tgl2 ?>&produk=<?= urlencode($produk_filter) ?>&jenis=<?= urlencode($jenis_filter) ?>" class="btn" style="background:#2196F3;">📥 Download Excel</a>
  </div>
</div>
</body>
</html>
