<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

<?php
$host = "localhost";
$user = "odmr9632_userdb";
$pass = "@Sukabumi2018";
$db   = "odmr9632_order_db";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}
?>
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';

$cs_list = $conn->query("SELECT DISTINCT nama_cs FROM cs");
$produk_list = $conn->query("SELECT nama_produk FROM produk_fisik UNION SELECT nama_produk FROM produk_digital");

$filter_tgl = $_GET['tanggal'] ?? '';
$filter_cs = $_GET['nama_cs'] ?? '';
$filter_produk = $_GET['nama_produk'] ?? '';

$where = "WHERE 1=1";
if ($filter_tgl) $where .= " AND tanggal='$filter_tgl'";
if ($filter_cs) $where .= " AND nama_cs='$filter_cs'";
if ($filter_produk) $where .= " AND nama_produk='$filter_produk'";

$rekap = [];
$q = "SELECT tanggal, nama_cs, nama_produk,
             SUM(harga_jual) as total_jual,
             SUM(qty) as total_qty,
             SUM(ongkir) as total_ongkir,
             SUM(biaya_iklan) as total_iklan,
             SUM(ppn) as total_ppn
      FROM orders
      $where
      GROUP BY tanggal, nama_cs, nama_produk
      ORDER BY tanggal DESC";
$res = $conn->query($q);

while ($row = $res->fetch_assoc()) {
  $produk = $conn->real_escape_string($row['nama_produk']);
  $cs = $conn->real_escape_string($row['nama_cs']);
  $tanggal = $conn->real_escape_string($row['tanggal']);

  $hpp = 0;
  $get_hpp = $conn->query("SELECT hpp FROM produk_fisik WHERE nama_produk='$produk'");
  if ($get_hpp && $get_hpp->num_rows > 0) {
    $row_hpp = $get_hpp->fetch_assoc();
    $hpp = isset($row_hpp['hpp']) ? (int)$row_hpp['hpp'] : 0;
  } else {
    $get_hpp = $conn->query("SELECT hpp FROM produk_digital WHERE nama_produk='$produk'");
    if ($get_hpp && $get_hpp->num_rows > 0) {
      $row_hpp = $get_hpp->fetch_assoc();
      $hpp = isset($row_hpp['hpp']) ? (int)$row_hpp['hpp'] : 0;
    }
  }

  $total_hpp = $hpp * $row['total_qty'];
  $profit = $row['total_jual'] - $total_hpp - $row['total_iklan'] - $row['total_ppn'];

  $rekap[] = [
    'tanggal' => $row['tanggal'],
    'cs' => $row['nama_cs'],
    'produk' => $row['nama_produk'],
    'jual' => $row['total_jual'],
    'hpp' => $total_hpp,
    'ongkir' => $row['total_ongkir'],
    'iklan' => $row['total_iklan'],
    'ppn' => $row['total_ppn'],
    'profit' => $profit
  ];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Update Biaya Ads</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f8f8f8; padding: 30px; }
    .container { max-width: 1000px; margin: auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    input, select, button {
      width: 100%; padding: 10px; margin: 10px 0;
      border-radius: 6px; border: 1px solid #ccc; box-sizing: border-box;
    }
    button {
      background: #f44336; color: white; border: none; cursor: pointer;
    }
    button:hover { background: #d32f2f; }
    table { width: 100%; border-collapse: collapse; margin-top: 30px; }
    th, td { padding: 10px; border: 1px solid #ddd; text-align: center; }
    th { background-color: #f44336; color: white; }
    .msg { text-align: center; color: green; font-weight: bold; }
    .back-btn { display: block; margin-top: 30px; text-align: center; background: gray; color: white; padding: 10px; border-radius: 6px; text-decoration: none; }
    .edit-link { font-size: 13px; color: #fff; background: #4CAF50; padding: 4px 10px; border-radius: 4px; text-decoration: none; }
  </style>
</head>
<body>
<div class="container">
  <h2>📢 Update Biaya Ads</h2>
  <form method="GET">
    <label>Tanggal:</label>
    <input type="date" name="tanggal" value="<?= $filter_tgl ?>">
    <label>Nama CS:</label>
    <select name="nama_cs">
      <option value="">-- Semua CS --</option>
      <?php $cs_list->data_seek(0); while($cs = $cs_list->fetch_assoc()): ?>
        <option value="<?= $cs['nama_cs'] ?>" <?= $filter_cs == $cs['nama_cs'] ? 'selected' : '' ?>><?= $cs['nama_cs'] ?></option>
      <?php endwhile; ?>
    </select>
    <label>Nama Produk:</label>
    <select name="nama_produk">
      <option value="">-- Semua Produk --</option>
      <?php $produk_list->data_seek(0); while($pr = $produk_list->fetch_assoc()): ?>
        <option value="<?= $pr['nama_produk'] ?>" <?= $filter_produk == $pr['nama_produk'] ? 'selected' : '' ?>><?= $pr['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>
    <button type="submit">🔍 Filter</button>
  </form>

  <h3>📊 Ringkasan Order</h3>
  <table>
    <thead>
      <tr>
        <th>Tanggal</th>
        <th>Nama CS</th>
        <th>Produk</th>
        <th>Harga Jual</th>
        <th>HPP</th>
        <th>Ongkir</th>
        <th>Biaya Iklan</th>
        <th>PPN</th>
        <th>PROFIT</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rekap as $r): ?>
      <tr>
        <td><?= $r['tanggal'] ?></td>
        <td><?= $r['cs'] ?></td>
        <td><?= $r['produk'] ?></td>
        <td>Rp<?= number_format($r['jual']) ?></td>
        <td>Rp<?= number_format($r['hpp']) ?></td>
        <td>Rp<?= number_format($r['ongkir']) ?></td>
        <td>Rp<?= number_format($r['iklan']) ?></td>
        <td>Rp<?= number_format($r['ppn']) ?></td>
        <td><b>Rp<?= number_format($r['profit']) ?></b></td>
        <td><a class="edit-link" href="edit_form_admin.php?tanggal=<?= $r['tanggal'] ?>&cs=<?= $r['cs'] ?>&produk=<?= $r['produk'] ?>">Edit</a></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <a href="menu_admin.php" class="back-btn">⬅️ Kembali ke Menu Admin</a>
</div>
</body>
</html>
