<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$tanggal = $_GET['tanggal'] ?? '';
$cs = $_GET['cs'] ?? '';
$produk = $_GET['produk'] ?? '';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $tanggal = $_POST['tanggal'];
  $cs = $_POST['nama_cs'];
  $produk = $_POST['nama_produk'];
  $biaya_iklan = (int) $_POST['biaya_iklan'];
  $ppn = (int) $_POST['ppn'];

  // Update semua baris orders yang cocok
  $stmt = $conn->prepare("UPDATE orders SET biaya_iklan = ?, ppn = ? WHERE tanggal = ? AND nama_cs = ? AND nama_produk = ?");
  $stmt->bind_param("iisss", $biaya_iklan, $ppn, $tanggal, $cs, $produk);

  if ($stmt->execute()) {
    $msg = '✅ Data berhasil disimpan ke orders';
  } else {
    $msg = '❌ Gagal menyimpan data';
  }
}

// Ambil salah satu data biaya_iklan & ppn untuk ditampilkan di form
$biaya = $conn->prepare("SELECT biaya_iklan, ppn FROM orders WHERE tanggal=? AND nama_cs=? AND nama_produk=? LIMIT 1");
$biaya->bind_param("sss", $tanggal, $cs, $produk);
$biaya->execute();
$result = $biaya->get_result();
$data = $result->fetch_assoc();
$iklan = $data['biaya_iklan'] ?? 0;
$ppn = $data['ppn'] ?? 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Biaya Iklan</title>
  <style>
    body { font-family: Arial; background: #f5f5f5; padding: 30px; }
    .box { max-width: 500px; margin: auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    input, button { width: 100%; padding: 10px; margin-top: 10px; border-radius: 6px; border: 1px solid #ccc; box-sizing: border-box; }
    button { background: #f44336; color: white; border: none; cursor: pointer; }
    button:hover { background: #d32f2f; }
    .msg { color: green; font-weight: bold; text-align: center; margin-top: 10px; }
    .back-link { text-align: center; display: block; margin-top: 20px; text-decoration: none; color: #f44336; }
  </style>
</head>
<body>
  <div class="box">
    <h2>✏️ Edit Biaya Iklan</h2>
    <form method="POST">
      <input type="hidden" name="tanggal" value="<?= htmlspecialchars($tanggal) ?>">
      <input type="hidden" name="nama_cs" value="<?= htmlspecialchars($cs) ?>">
      <input type="hidden" name="nama_produk" value="<?= htmlspecialchars($produk) ?>">

      <label>Biaya Iklan:</label>
      <input type="number" name="biaya_iklan" value="<?= $iklan ?>" required>
      <label>PPN:</label>
      <input type="number" name="ppn" value="<?= $ppn ?>" required>
      <button type="submit">💾 Simpan Perubahan</button>
    </form>
    <?php if ($msg): ?><p class="msg"><?= $msg ?></p><?php endif; ?>
    <a href="tambah_biaya_ads.php" class="back-link">⬅️ Kembali</a>
  </div>
</body>
</html>
