<?php
session_start();
if (!isset($_SESSION['warehouse'])) {
  header("Location: login_warehouse.php");
  exit;
}

$conn = new mysqli("localhost", "root", "", "order_db");
if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama = trim($_POST['nama_produk']);
  $stok_awal = (int)$_POST['stok_awal'];
  $petugas = $_SESSION['warehouse'];

  if ($nama !== '') {
    // Tambahkan produk
    $stmt = $conn->prepare("INSERT INTO produk_fisik (nama_produk, stok_awal, stok_masuk, stok_keluar, stok_rusak, stok_hilang, stok) VALUES (?, ?, 0, 0, 0, 0, ?)");
    $stmt->bind_param("sii", $nama, $stok_awal, $stok_awal);
    $stmt->execute();

    // Catat ke riwayat
    $stmt2 = $conn->prepare("INSERT INTO riwayat_stok (nama_produk, jenis, qty, keterangan, tanggal, petugas) VALUES (?, 'masuk', ?, ?, NOW(), ?)");
    $ket = "Stok awal saat penambahan produk";
    $stmt2->bind_param("siss", $nama, $stok_awal, $ket, $petugas);
    $stmt2->execute();

    $msg = "✅ Produk berhasil ditambahkan!";
  } else {
    $msg = "❌ Nama produk tidak boleh kosong.";
  }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Tambah Produk - Gudang</title>
  <style>
    body { font-family: Arial; background: #f0f0f0; padding: 20px; }
    .box { max-width: 500px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #d84315; }
    label { display: block; margin-top: 15px; }
    input[type="text"], input[type="number"] {
      width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px;
    }
    .btn { margin-top: 20px; background: #d84315; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
    .msg { margin-top: 15px; text-align: center; color: green; }
  </style>
</head>
<body>
<div class="box">
  <h2>➕ Tambah Produk Baru</h2>
  <?php if ($msg): ?><div class="msg"><?= $msg ?></div><?php endif; ?>
  <form method="post">
    <label>Nama Produk</label>
    <input type="text" name="nama_produk" required>

    <label>Stok Awal</label>
    <input type="number" name="stok_awal" value="0" min="0" required>

    <button type="submit" class="btn">Simpan Produk</button>
  </form>
  <div style="text-align:center; margin-top:20px;">
    <a href="dashboard_warehouse.php">⬅️ Kembali ke Dashboard</a>
  </div>
</div>
</body>
</html>
