<?php include 'koneksi.php'; ?>
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

// Load nilai manual (jika belum ada, buat default)
$manual = [
  'saldo_rekening' => 0,
  'utang' => 0,
  'modal_awal' => 1000000
];
$result = $conn->query("SELECT nama, nilai FROM neraca_setting");
while ($row = $result->fetch_assoc()) {
  $manual[$row['nama']] = (int)$row['nilai'];
}

// Kas = uang dari order terkirim (harga_jual - biaya iklan - ppn)
$kas = 0;
$result = $conn->query("SELECT SUM(harga_jual - biaya_iklan - ppn) as total_kas FROM orders WHERE status_pengiriman = 'Terkirim'");
if ($result && $row = $result->fetch_assoc()) {
  $kas = (int)$row['total_kas'];
}

// Piutang dari order belum terkirim
$piutang = 0;
$result = $conn->query("SELECT SUM(harga_jual) as total_piutang FROM orders WHERE status_pengiriman != 'Terkirim'");
if ($result && $row = $result->fetch_assoc()) {
  $piutang = (int)$row['total_piutang'];
}

// Persediaan = stok * hpp
$persediaan = 0;
$result = $conn->query("SELECT stok, hpp FROM produk_fisik");
while ($row = $result->fetch_assoc()) {
  $persediaan += $row['stok'] * $row['hpp'];
}

$aktiva = $kas + $piutang + $persediaan + $manual['saldo_rekening'];
$laba_ditahan = $aktiva - $manual['utang'] - $manual['modal_awal'];
$pasiva = $manual['utang'] + $manual['modal_awal'] + $laba_ditahan;

// Update nilai jika disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  foreach ($_POST as $key => $val) {
    $val = (int)$val;
    $conn->query("REPLACE INTO neraca_setting (nama, nilai) VALUES ('$key', $val)");
  }
  header("Location: laporan_neraca.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Laporan Neraca</title>
  <style>
    body { font-family: Arial; padding: 30px; background: #f5f5f5; }
    .container { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    h2 { text-align: center; color: #3f51b5; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: left; }
    th { background: #3f51b5; color: white; text-align: center; }
    input { width: 100%; padding: 6px; box-sizing: border-box; }
    .btn { background: #4CAF50; color: white; border: none; padding: 10px 20px; margin-top: 10px; border-radius: 6px; cursor: pointer; }
    .btn:hover { background: #388e3c; }
    .desc { font-size: 12px; color: #666; }
  </style>
</head>
<body>
<div class="container">
  <h2>📘 Laporan Neraca</h2>
  <form method="post">
    <h3>Aktiva</h3>
    <table>
      <tr><th>Kategori</th><th>Nilai</th></tr>
      <tr><td>Kas <div class="desc">(uang masuk dari order terkirim: harga jual - iklan - ppn)</div></td><td>Rp<?= number_format($kas) ?></td></tr>
      <tr><td>Saldo Rekening <div class="desc">(dapat diubah manual jika ada transferan langsung)</div></td><td><input type="number" name="saldo_rekening" value="<?= $manual['saldo_rekening'] ?>"></td></tr>
      <tr><td>Piutang <div class="desc">(dari order yang belum terkirim)</div></td><td>Rp<?= number_format($piutang) ?></td></tr>
      <tr><td>Persediaan <div class="desc">(stok produk * HPP)</div></td><td>Rp<?= number_format($persediaan) ?></td></tr>
      <tr><td><strong>Total Aktiva</strong></td><td><strong>Rp<?= number_format($aktiva) ?></strong></td></tr>
    </table>

    <h3>Pasiva</h3>
    <table>
      <tr><th>Kategori</th><th>Nilai</th></tr>
      <tr><td>Utang <div class="desc">(kewajiban yang belum dilunasi, bisa isi manual)</div></td><td><input type="number" name="utang" value="<?= $manual['utang'] ?>"></td></tr>
      <tr><td>Modal <div class="desc">(nilai modal awal usaha)</div></td><td><input type="number" name="modal_awal" value="<?= $manual['modal_awal'] ?>"></td></tr>
      <tr><td>Laba Ditahan <div class="desc">(dihitung otomatis dari total aktiva - utang - modal)</div></td><td>Rp<?= number_format($laba_ditahan) ?></td></tr>
      <tr><td><strong>Total Pasiva</strong></td><td><strong>Rp<?= number_format($pasiva) ?></strong></td></tr>
    </table>

    <div style="text-align:center;">
      <button class="btn" type="submit">💾 Simpan Nilai Manual</button>
    </div>
  </form>

  <div style="text-align:center; margin-top: 40px;">
    <a href="menu_admin.php" style="padding: 10px 20px; background: gray; color: white; text-decoration: none; border-radius: 6px;">⬅️ Kembali ke Menu Admin</a>
  </div>
</div>
</body>
</html>
