<?php include 'koneksi.php'; ?>
<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login_admin.php");
  exit;
}

if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$provinsi_list = [
  'Jawa Barat', 'Jawa Tengah', 'Jawa Timur', 'DKI Jakarta', 'Yogyakarta', 'Luar Jawa'
];

// Simpan perubahan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  foreach ($_POST['potongan'] as $provinsi => $potongan) {
    $prov = $conn->real_escape_string($provinsi);
    $val = (int) $potongan;
    
    $cek = $conn->query("SELECT id FROM cashback_setting WHERE provinsi='$prov'");
    if ($cek->num_rows > 0) {
      $conn->query("UPDATE cashback_setting SET potongan=$val WHERE provinsi='$prov'");
    } else {
      $conn->query("INSERT INTO cashback_setting (provinsi, potongan) VALUES ('$prov', $val)");
    }
  }
  $msg = "✅ Pengaturan berhasil disimpan.";
}

// Ambil data saat ini
$data = $conn->query("SELECT * FROM cashback_setting");
$cashback_setting = [];
while ($row = $data->fetch_assoc()) {
  $cashback_setting[$row['provinsi']] = $row['potongan'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Pengaturan Cashback</title>
  <style>
    body { font-family: Arial; background: #eee; padding: 40px; }
    .box { max-width: 600px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    h2 { text-align: center; color: #f44336; }
    label { display: block; margin-top: 15px; font-weight: bold; }
    input[type=number] { width: calc(100% - 50px); padding: 8px; margin-top: 5px; border: 1px solid #ccc; border-radius: 5px; }
    button { margin-top: 20px; width: 100%; padding: 10px; background: #f44336; color: white; border: none; border-radius: 6px; cursor: pointer; }
    button:hover { background: #d32f2f; }
    .note { font-size: 13px; color: gray; text-align: center; margin-top: 10px; }
    .footer-links { text-align: center; margin-top: 30px; }
    .footer-links a { padding: 10px 20px; background: gray; color: white; text-decoration: none; border-radius: 6px; margin: 0 10px; }
  </style>
</head>
<body>
<div class="box">
  <h2>📁 Pengaturan Cashback Per Provinsi</h2>

  <?php if (!empty($msg)): ?><p style="color:green; text-align:center; font-weight:bold;"><?= $msg ?></p><?php endif; ?>

  <form method="POST">
    <?php foreach ($provinsi_list as $prov): ?>
      <label><?= $prov ?></label>
      <div style="position: relative;">
        <input type="number" 
               name="potongan[<?= $prov ?>]" 
               value="<?= $cashback_setting[$prov] ?? 0 ?>">
        <?php if ($prov === 'Luar Jawa'): ?>
          <span style="position: absolute; right: 10px; top: 10px;">%</span>
        <?php else: ?>
          <span style="position: absolute; right: 10px; top: 10px;">Rp</span>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
    <button type="submit">📂 Simpan</button>
  </form>

  <div class="footer-links">
    <a href="laporan.php">📊 Kembali ke Laporan</a>
    <a href="menu_admin.php">📄 Menu Admin</a>
    <a href="index.php">🏠 Menu Utama</a>
  </div>
</div>
</body>
</html>
