<?php include 'koneksi.php'; ?>
<?php
session_start();
if (!isset($_SESSION['warehouse'])) {
  header("Location: login_warehouse.php");
  exit;
}

if ($conn->connect_error) {
  die("Koneksi gagal: " . $conn->connect_error);
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama_produk = $_POST['nama_produk'];
  $qty = (int) $_POST['jumlah'];
  $keterangan = $_POST['keterangan'];

  // Catat ke riwayat
  $stmt = $conn->prepare("INSERT INTO riwayat_stok (nama_produk, jenis, qty, keterangan, tanggal) VALUES (?, 'masuk', ?, ?, NOW())");
  if ($stmt) {
    $stmt->bind_param("sis", $nama_produk, $qty, $keterangan);
    $stmt->execute();
  } else {
    die("❌ Query gagal: " . $conn->error);
  }

  // Update ke stok
  $stmt2 = $conn->prepare("UPDATE produk_fisik SET stok_masuk = stok_masuk + ?, stok = stok + ? WHERE nama_produk = ?");
  if ($stmt2) {
    $stmt2->bind_param("iis", $qty, $qty, $nama_produk);
    $stmt2->execute();
    $msg = "✅ Stok berhasil ditambahkan!";
  } else {
    die("❌ Update gagal: " . $conn->error);
  }
}

// Ambil daftar produk
$produk_list = $conn->query("SELECT nama_produk FROM produk_fisik");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Tambah Stok Masuk</title>
  <style>
    body { font-family: Arial; background: #f0f0f0; padding: 20px; }
    .box { max-width: 500px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px #ccc; }
    h2 { text-align: center; color: #4CAF50; }
    label { display: block; margin-top: 15px; }
    input, select, textarea {
      width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px;
    }
    .btn { margin-top: 20px; background: #4CAF50; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
    .msg { margin-top: 15px; text-align: center; color: green; }
  </style>
</head>
<body>
<div class="box">
  <h2>➕ Tambah Stok Masuk</h2>
  <?php if ($msg): ?><div class="msg"><?= $msg ?></div><?php endif; ?>
  <form method="post">
    <label>Nama Produk</label>
    <select name="nama_produk" required>
      <option value="">-- Pilih Produk --</option>
      <?php while ($row = $produk_list->fetch_assoc()): ?>
        <option value="<?= $row['nama_produk'] ?>"><?= $row['nama_produk'] ?></option>
      <?php endwhile; ?>
    </select>

    <label>Jumlah Masuk</label>
    <input type="number" name="jumlah" required min="1">

    <label>Keterangan</label>
    <select name="keterangan" onchange="toggleKeteranganLain(this.value)">
      <option value="Pembelian">Pembelian</option>
      <option value="Return">Return</option>
      <option value="Lainnya">Lainnya</option>
    </select>
    <input type="text" name="keterangan_lain" id="keteranganLain" style="display:none;" placeholder="Keterangan lainnya">

    <button type="submit" class="btn">Simpan Stok</button>
  </form>
  <div style="text-align:center; margin-top:20px;">
    <a href="dashboard_warehouse.php">⬅️ Kembali ke Dashboard</a>
  </div>
</div>

<script>
function toggleKeteranganLain(val) {
  const input = document.getElementById('keteranganLain');
  if (val === 'Lainnya') {
    input.style.display = 'block';
    input.name = 'keterangan';
  } else {
    input.style.display = 'none';
    input.name = 'keterangan_lain';
  }
}
</script>
</body>
</html>
