<?php
include 'config/koneksi.php';
include 'config/config.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$produk = $conn->query("SELECT * FROM produk WHERE id = $id")->fetch_assoc();
$varian = $conn->query("SELECT * FROM produk_varian WHERE produk_id = $id ORDER BY harga ASC");
$minmax = $conn->query("SELECT MIN(harga) AS min_harga, MAX(harga) AS max_harga FROM produk_varian WHERE produk_id = $id")->fetch_assoc();
$gambar_slider = $conn->query("SELECT url_gambar FROM produk_gambar WHERE produk_id = $id");

$min = $minmax['min_harga'] ?? $produk['harga'];
$max = $minmax['max_harga'] ?? $produk['harga'];

$gambar_utama = $produk['thumbnail_url'];
$jumlah_gambar = $gambar_slider->num_rows + 1;
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Checkout - <?= $produk['nama_produk'] ?></title>
  <link rel="stylesheet" href="assets/style.css">
  <style>
    body {
      background-color: #f5f5f5;
      padding-bottom: 80px;
    }
    .checkout-wrapper {
      max-width: 1200px;
      margin: 30px auto;
      padding: 24px;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.06);
    }
    .checkout-container {
      display: flex;
      flex-wrap: wrap;
      gap: 24px;
    }
    .checkout-image {
      flex: 1 1 400px;
      position: relative;
    }
    .checkout-image img {
      width: 100%;
      aspect-ratio: 1/1;
      object-fit: cover;
      border-radius: 0;
      margin-bottom: 8px;
    }
    .indikator-slide {
      position: absolute;
      bottom: 10px;
      right: 10px;
      background: rgba(0,0,0,0.5);
      color: #fff;
      padding: 4px 8px;
      font-size: 12px;
      border-radius: 12px;
    }
    .slider-container {
      display: flex;
      gap: 8px;
      overflow-x: auto;
    }
    .slider-container img {
      width: 60px;
      height: 60px;
      object-fit: cover;
      border-radius: 6px;
      border: 2px solid #ccc;
      cursor: pointer;
      flex-shrink: 0;
    }
    .slider-container img:hover {
      border-color: #ffc357;
    }

    .checkout-info h2 {
      color: red;
      margin: 0 0 0px;
    }
    .checkout-info h3 {
      margin: 0 0 4px;
      border-bottom: 1px solid #ccc;
      padding-bottom: 6px;
    }
    .rating {
      font-size: 14px;
      margin-bottom: 4px;
    }
    .varian-label {
      font-weight: bold;
      margin: 12px 0 6px;
    }
    .varian-label span {
      color: #888;
      font-weight: normal;
    }
    .varian-list {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin: 10px 0;
    }
    .varian-item {
      padding: 8px 10px;
      background: #f8f8f8;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 13px;
      text-align: center;
    }
    .deskripsi {
      font-size: 14px;
      margin-bottom: 20px;
    }
    .beli-button {
      background: #ffc357;
      color: white;
      padding: 14px;
      border: none;
      width: 100%;
      font-weight: bold;
      font-size: 16px;
      border-radius: 8px;
      cursor: pointer;
      margin-top: 20px;
    }
    .checkout-form {
      display: none;
      margin-top: 20px;
    }
    .checkout-form input[type="text"],
    .checkout-form input[type="email"] {
      width: 100%;
      padding: 12px;
      border-radius: 8px;
      border: 1px solid #ccc;
      margin-bottom: 12px;
    }
    .back-button {
      display: inline-block;
      margin-bottom: 20px;
      text-decoration: none;
      color: #333;
      background: #eee;
      padding: 6px 12px;
      border-radius: 6px;
    }

    @media (max-width: 768px) {
      .beli-button {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        border-radius: 0;
        z-index: 999;
        margin: 0;
      }
      .checkout-container {
        flex-direction: column;
      }
    }
  </style>
</head>
<body>
<div class="checkout-wrapper">
  <a href="produk.php" class="back-button">&larr; Kembali</a>
  <div class="checkout-container">
    <div class="checkout-image">
      <img id="mainImage" src="<?= $gambar_utama ?>" alt="<?= $produk['nama_produk'] ?>">
      <div class="indikator-slide"><?= $jumlah_gambar ?> Foto</div>
      <div class="slider-container">
        <img src="<?= $produk['thumbnail_url'] ?>" onclick="document.getElementById('mainImage').src=this.src">
        <?php
          mysqli_data_seek($gambar_slider, 0);
          while ($gs = $gambar_slider->fetch_assoc()):
        ?>
          <img src="<?= $gs['url_gambar'] ?>" onclick="document.getElementById('mainImage').src=this.src">
        <?php endwhile; ?>
      </div>
    </div>
    <div class="checkout-info">
      <div class="rating">⭐ <strong>5.0</strong> | 10k++ Terjual</div>
      <h2>Rp <?= number_format($min, 0, ',', '.') ?><?= ($min != $max ? ' - Rp ' . number_format($max, 0, ',', '.') : '') ?></h2>
      <h3><?= htmlspecialchars($produk['nama_produk']) ?></h3>

      <div class="varian-label">
        Pilih variasi <span>(<?= $varian->num_rows ?> VARIAN)</span>
      </div>
      <form id="pilihVarianForm">
  <div class="varian-list">
    <?php while ($v = $varian->fetch_assoc()): ?>
      <label class="varian-item">
        <input type="radio" name="varian" value="<?= htmlspecialchars($v['nama_varian']) ?>" required style="margin-right:6px;">
        <?= htmlspecialchars($v['nama_varian']) ?>
      </label>
    <?php endwhile; ?>
  </div>
</form>


      <div class="deskripsi">
        <strong style="display:block; margin-bottom:4px;">Keterangan</strong>
        <?= nl2br(htmlspecialchars($produk['deskripsi'])) ?>
      </div>

      <button class="beli-button" onclick="window.location.href='<?= htmlspecialchars($produk['checkout_link']) ?>'">
        Beli Sekarang
      </button>

      <form action="proses_checkout.php" method="POST" class="checkout-form">
        <input type="hidden" name="produk_id" value="<?= $produk['id'] ?>">
        <label>Nama Lengkap</label>
        <input type="text" name="nama" required>

        <label>No WhatsApp</label>
        <input type="text" name="wa" required>

        <label>Email</label>
        <input type="email" name="email">

        <button type="submit" class="beli-button">Kirim Order</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
