<?php
include 'config/koneksi.php';
include 'config/config.php';

$keyword = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

$query = "SELECT * FROM produk";
if ($keyword !== '') {
    $query .= " WHERE nama_produk LIKE '%$keyword%'";
}
$query .= " ORDER BY created_at DESC";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?= $toko_nama ?> - Produk Digital</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="google-site-verification" content="-rnOp_IAVmwRTJnpe4MEY5etEETi2fXQ-Zgx_OWahe4" />
    <!-- Meta SEO -->
  <meta name="description" content="Toko digital terpercaya menjual akun Canva Pro, Netflix Premium, Capcut dan produk digital lainnya.">
  <meta name="keywords" content="Canva Pro, Rcti Plus, Filmora Premium, Berlangganan Canva Pro Murah,Cara Tambah Follower Tiktok,Cara Nambah Follower IG, Cara nambah follower fb, Jual Akun Premium, Capcut Pro, Netflix Premium, Toko Digital Murah">
  <meta name="robots" content="index, follow">
  <!-- Favicon -->
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="manifest" href="/site.webmanifest">

    <link rel="stylesheet" href="assets/style.css?v=<?= time() ?>">
    <style>
  .slider-wrapper {
    position: relative;
    overflow-x: auto;
    white-space: nowrap;
    -webkit-overflow-scrolling: touch;
    scroll-snap-type: x mandatory;
  }
  .slider-wrapper img {
    width: 100%;
    max-width: 100%;
    height: auto;
    display: inline-block;
    scroll-snap-align: start;
  }
  .indicator {
    position: absolute;
    bottom: 10px;
    right: 10px;
    background: rgba(0, 0, 0, 0.5);
    color: #fff;
    padding: 4px 8px;
    font-size: 12px;
    border-radius: 12px;
  }
  .slider-container {
    display: flex;
    gap: 8px;
    margin-top: 10px;
    overflow-x: auto;
  }
  .slider-container img {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 6px;
    border: 2px solid #ccc;
    cursor: pointer;
    flex-shrink: 0;
  }
  .slider-container img:hover {
    border-color: #ffc357;
  }

  /* FIX RESPONSIVE MOBILE */
  .produk-list {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 12px;
    margin-top: 20px;
  }

  .produk-item {
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 10px;
    display: flex;
    flex-direction: column;
    text-align: left;
  }

  .produk-img {
    width: 100%;
    aspect-ratio: 1 / 1;
    object-fit: cover;
    border-radius: 6px;
    margin-bottom: 8px;
  }

  html, body {
    overflow-x: hidden;
  }

  .container {
    width: 100%;
    max-width: 1080px;
    margin: auto;
    padding: 16px;
  }

  @media (max-width: 480px) {
    .container {
      padding: 8px;
    }
  }
</style>


    </style>
    <script>
      function updateImage(productId, src, index, total) {
        const main = document.getElementById('mainImage' + productId);
        const indicator = document.getElementById('indicator' + productId);
        main.src = src;
        indicator.textContent = (index + 1) + '/' + total;
      }
    </script>
</head>
<body>
<div style="background-color: #ffc357; padding: 10px 16px; display: flex; align-items: center; justify-content: center; flex-wrap: wrap;">
  <img src="assets/logo_akunkuy.jpg" alt="Akunkuy" style="height: 36px; margin-right: 12px;">
  <span style="font-weight: bold; font-size: 18px; color: black;">AKUNKUY</span>
  <form method="get" action="produk.php" style="display: flex; margin-top: 8px; width: 100%; max-width: 600px; justify-content: center;">
    <input type="text" name="search" placeholder="Cari produk..." 
           style="flex: 1; max-width: 480px; padding: 8px 12px; border: none; border-radius: 6px 0 0 6px;">
    <button type="submit" 
            style="background-color: #FFC357; border: none; padding: 8px 16px; border-radius: 0 6px 6px 0; cursor: pointer;">
      🔍
    </button>
  </form>
</div>
<div class="container">
    <h1>Jual Produk Digital Bergaransi & Terpercaya</h1>
    <div class="produk-list">
        <?php while ($row = $result->fetch_assoc()):
            $produk_id = $row['id'];
            $gambar_slider = $conn->query("SELECT url_gambar FROM produk_gambar WHERE produk_id = $produk_id");
            $slider_array = [$row['thumbnail_url']];
            while ($gs = $gambar_slider->fetch_assoc()) $slider_array[] = $gs['url_gambar'];
            $total = count($slider_array);
        ?>
        <div class="produk-item">
            <div class="slider-wrapper" id="wrapper<?= $produk_id ?>">
              <a href="checkout.php?id=<?= $row['id'] ?>">
  <img id="mainImage<?= $produk_id ?>" src="<?= $slider_array[0] ?>" alt="<?= $row['nama_produk'] ?>" class="produk-img">
</a>

              <div class="indicator" id="indicator<?= $produk_id ?>">1/<?= $total ?></div>
            </div>
            <div class="slider-container">
              <?php foreach ($slider_array as $i => $img): ?>
                <img src="<?= $img ?>" onclick="updateImage(<?= $produk_id ?>, '<?= $img ?>', <?= $i ?>, <?= $total ?>)">
              <?php endforeach; ?>
            </div>
            <div style="font-size: 14px; color: #777;">⭐ 5.0 | 10k++ Terjual</div>
            <h3><?= htmlspecialchars($row['nama_produk']) ?></h3>
            <p class="price">
                Rp <?= number_format($row['harga'], 0, ',', '.') ?>
            </p>
            <p><?= substr(strip_tags($row['deskripsi']), 0, 60) ?>...</p>
            <a href="checkout.php?id=<?= $row['id'] ?>" class="button">Lihat Selengkapnya</a>
        </div>
        <?php endwhile; ?>
    </div>
</div>
</body>
</html>
