<?php
session_start();
include 'config/koneksi.php';
include 'config/config.php';

// Cek login
if (!isset($_SESSION['admin_logged_in'])) {
  header("Location: login_admin.php");
  exit;
}

// Ambil semua produk
$query = "SELECT * FROM produk ORDER BY created_at DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Admin - <?= $toko_nama ?></title>
  <link rel="stylesheet" href="assets/style.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f9f9f9;
      padding: 30px;
    }
    .container {
      max-width: 1100px;
      margin: auto;
      background: white;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }
    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      margin-bottom: 20px;
    }
    .logo-title {
      display: flex;
      align-items: center;
      gap: 12px;
    }
    .logo {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      overflow: hidden;
      border: 2px solid #FFCF57;
    }
    .logo img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }
    .title {
      font-size: 22px;
      font-weight: bold;
      color: #333;
    }
    .actions {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
      margin-top: 10px;
    }
    .btn {
      background: #ffc357;
      color: white;
      padding: 10px 14px;
      border: none;
      border-radius: 6px;
      text-decoration: none;
      display: inline-block;
    }
    .btn.logout {
      background: #dc3545;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th, td {
      border: 1px solid #ddd;
      padding: 10px;
      text-align: left;
    }
    th {
      background: #f2f2f2;
    }
    .aksi a {
      margin-right: 6px;
      text-decoration: none;
      color: white;
      padding: 6px 10px;
      border-radius: 4px;
    }
    .edit {
      background: #007bff;
    }
    .hapus {
      background: #dc3545;
    }

    @media (max-width: 600px) {
      .header {
        flex-direction: column;
        align-items: center;
      }
      .logo-title {
        flex-direction: column;
      }
      .actions {
        justify-content: center;
      }
    }
  </style>
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo-title">
      <div class="logo">
        <img src="assets/logo_akunkuy.jpg" alt="Logo">
      </div>
      <span class="title">Dashboard Produk Digital</span>
    </div>
    <div class="actions">
      <a href="tambah_produk.php" class="btn">+ Tambah Produk</a>
      <a href="logout_admin.php" class="btn logout">Logout</a>
    </div>
  </div>

  <table>
    <thead>
      <tr>
        <th>Gambar</th>
        <th>Nama Produk</th>
        <th>Harga</th>
        <th>Kategori</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
          <td><img src="<?= $row['thumbnail_url'] ?>" alt="thumb" width="60"></td>
          <td><?= htmlspecialchars($row['nama_produk']) ?></td>
          <td>Rp <?= number_format($row['harga'], 0, ',', '.') ?></td>
          <td><?= htmlspecialchars($row['kategori']) ?></td>
          <td class="aksi">
            <a href="edit_produk.php?id=<?= $row['id'] ?>" class="edit">Edit</a>
            <a href="hapus_produk.php?id=<?= $row['id'] ?>" class="hapus" onclick="return confirm('Yakin ingin menghapus produk ini?')">Hapus</a>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>
