<?php
$host = "localhost";
$user = "root";
$pass = "";

// 1. Koneksi ke MySQL tanpa database
$conn = new mysqli($host, $user, $pass);
if ($conn->connect_error) {
    die("❌ Koneksi gagal: " . $conn->connect_error);
}

// 2. Buat database jika belum ada
$sql = "CREATE DATABASE IF NOT EXISTS tokodigital_db";
if ($conn->query($sql) === TRUE) {
    echo "✅ Database 'tokodigital_db' berhasil dibuat atau sudah ada.<br>";
} else {
    die("❌ Gagal membuat database: " . $conn->error);
}

// 3. Gunakan database
$conn->select_db("tokodigital_db");

// 4. Buat tabel produk
$sql_produk = "CREATE TABLE IF NOT EXISTS produk (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_produk VARCHAR(255) NOT NULL,
    deskripsi TEXT,
    harga INT NOT NULL,
    file_url TEXT,
    thumbnail_url TEXT,
    kategori VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";
if ($conn->query($sql_produk)) {
    echo "✅ Tabel 'produk' berhasil dibuat.<br>";
} else {
    echo "❌ Gagal membuat tabel produk: " . $conn->error . "<br>";
}

// 5. Hapus tabel orders jika sudah ada (revisi ke versi tanpa login user)
$conn->query("DROP TABLE IF EXISTS orders");

// 6. Buat tabel orders tanpa user login
$sql_orders = "CREATE TABLE orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_customer VARCHAR(100) NOT NULL,
    no_wa VARCHAR(20),
    email VARCHAR(100),
    produk_id INT,
    status ENUM('pending','paid','cancelled') DEFAULT 'pending',
    bukti_transfer TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (produk_id) REFERENCES produk(id)
)";
if ($conn->query($sql_orders)) {
    echo "✅ Tabel 'orders' (tanpa login user) berhasil dibuat ulang.<br>";
} else {
    echo "❌ Gagal buat ulang tabel orders: " . $conn->error . "<br>";
}

$conn->close();
?>
